﻿using System;
using System.Globalization;
using System.IO;
using System.Net;
using System.Net.Http;
using System.Security.Cryptography;
using System.Text;
using VA.PPMS.CRM.Plugins.Data;

namespace VA.PPMS.CRM.Plugins.Helper
{
    public static class FabricHelper
    {
        public static string SubmitToQueue(PpmsServiceSettings settings, string message)
        {
            // Submit to queue
            using (var client = new HttpClient())
            {
                client.BaseAddress = new Uri(settings.QueueBaseAddress);

                var requestDate = DateTime.UtcNow.ToString("R", CultureInfo.InvariantCulture);
                const string storageServiceVersion = "2012-02-12";

                string messageText = String.Format("<QueueMessage><MessageText>{0}</MessageText></QueueMessage>", message);
                var utf8Encoding = new UTF8Encoding();
                var messageContent = utf8Encoding.GetBytes(messageText);
                var messageLength = messageContent.Length;

                var canonicalizedHeaders = string.Format("x-ms-date:{0}\nx-ms-version:{1}", requestDate, storageServiceVersion);
                var canonicalizedResource = string.Format("/{0}/{1}", settings.StorageAccountName, settings.StorageAccountResource);

                var stringToSign = string.Format("{0}\n\n\n{1}\n\n\n\n\n\n\n\n\n{2}\n{3}",
                    "POST",
                    messageLength,
                    canonicalizedHeaders,
                    canonicalizedResource);

                var authorizationHeader = CreateAuthorizationHeader(stringToSign, settings.StorageAccountName, settings.StorageAccountKey);

                client.DefaultRequestHeaders.Add("x-ms-date", requestDate);
                client.DefaultRequestHeaders.Add("x-ms-version", storageServiceVersion);
                client.DefaultRequestHeaders.Add("Authorization", authorizationHeader);

                var result = client.PostAsync(settings.StorageAccountResource, new ByteArrayContent(messageContent)).GetAwaiter().GetResult();
                return result.StatusCode.ToString();
            }
        }

        /// <summary>
        /// Lookup NPI status from validation list
        /// </summary>
        /// <param name="npi">Reference NPI</param>
        /// /// <param name="npiType">Reference NPI Type</param>
        public static string GetNpiStatus(string npi, string npiType, PpmsServiceSettings settings)
        {
            try
            {
                var uri = string.Format("{0}npistatus()?$filter= PartitionKey eq '{1}' and RowKey eq '{2}' and NpiType eq '{3}' and Status eq 'Active'",
                    settings.TableBaseAddress, GetPartitionKey(npi), npi, npiType);
                var request = (HttpWebRequest)WebRequest.Create(uri);
                request.ContentLength = 0;
                request.Headers.Add("x-ms-date", DateTime.UtcNow.ToString("R", CultureInfo.InvariantCulture));

                const string storageServiceVersion = "2015-12-11";

                var resource = request.RequestUri.PathAndQuery;
                if (resource.Contains("?"))
                {
                    resource = resource.Substring(0, resource.IndexOf("?"));
                }

                string stringToSign = string.Format("{0}\n{1}\n{2}\n{3}\n/{4}{5}",
                    request.Method,
                    request.Headers["Content-MD5"],
                    request.Headers["Content-Type"],
                    request.Headers["x-ms-date"],
                    settings.StorageAccountName,
                    resource);

                var authorizationHeader = CreateAuthorizationHeader(stringToSign, settings.StorageAccountName, settings.StorageAccountKey);

                request.Headers.Add("x-ms-version", storageServiceVersion);
                request.Headers.Add("Authorization", authorizationHeader);
                request.Accept = "application/json;odata=nometadata";

                var response = request.GetResponse();

                using (var sr = new StreamReader(response.GetResponseStream()))
                {
                    return sr.ReadToEnd();
                }
            }
            catch
            {
                return null;
            }
        }

        private static string CreateAuthorizationHeader(string canonicalizedString, string storageAccountName, string storageAccountKey)
        {
            string signature;

            using (var hmacSha256 = new HMACSHA256(Convert.FromBase64String(storageAccountKey)))
            {
                var dataToHmac = Encoding.UTF8.GetBytes(canonicalizedString);
                signature = Convert.ToBase64String(hmacSha256.ComputeHash(dataToHmac));
            }

            var authorizationHeader = string.Format(CultureInfo.InvariantCulture, "SharedKey {0}:{1}", storageAccountName, signature);

            return authorizationHeader;
        }

        private static string GetPartitionKey(string npi)
        {
            return npi.Substring(0, 2);
        }
    }
}
